;
;****************************************************************************
;
;  Purpose:
;	Common System Macros
;
;  Date:
;	11/23/93
;
;  Author:
;	John C. Wren
;
;  Modications:
;	02/04/97 - Added Description Fields For Archive
;
;  Processor:
;	Generic 8031
;
;  Assembler:
;	Avocet AVA51
;
;  Dependencies:
;	None
;
;  Files:
;	None
;
;  Philosophic:
;	None
;
;****************************************************************************
;
;  Description:
;	Performs A STOP Function By Disabling Interrupts And Looping
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	None
;
;  Stack:
;	None
;
;  Comments:
;	None
;
stop	%macro
	clr	ea
	jmp	$
	%endm
; 
;****************************************************************************
;
;  Description:
;	Implements A Compare And Jump Equal Function
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	None
;
;  Comments:
;	None
;
cjeq    %macro  parm1,parm2,parm3
	%gensym	temp
        cjne    parm1,parm2,temp
        jmp    	parm3
temp
        %endm
;****************************************************************************
;
;  Description:
;	Implements A Compare And Jump Less Than Instruction
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	None
;
;  Comments:
;	None
;
cjlt    %macro  parm1,parm2,parm3
	%gensym	temp
        cjne    parm1,parm2,temp
temp	jc      parm3
        %endm
;****************************************************************************
;
;  Description:
;	Implements A Compare And Jump Less Or Equal Instruction
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	None
;
;  Comments:
;	None
;
cjle    %macro  parm1,parm2,parm3
	%gensym	temp
        cjne    parm1,parm2,temp
	jmp	parm3
temp	jc      parm3
        %endm
;****************************************************************************
;
;  Description:
;	Implements A Compare And Jump Greater Than Instruction
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	None
;
;  Comments:
;	None
;
cjgt    %macro  parm1,parm2,parm3
	%gensym	temp
	%gensym	temp2
        cjne    parm1,parm2,temp
	jmp	temp2
temp	jnc     parm3
temp2
        %endm
;****************************************************************************
;
;  Description:
;	Implements A Compare And Jump Greater Than Or Equal Instruction
;
;  Entry Requirements:
;	None
;
;  On Exit:
;	None
;
;  Affected:
;	PSW.CY
;
;  Stack:
;	None
;
;  Comments:
;	None
;
cjge    %macro  parm1,parm2,parm3
	%gensym	temp
        cjne    parm1,parm2,temp
temp	jnc     parm3
        %endm
;        
;****************************************************************************
; 

